
*****************************************************
*           REGRESSIONSANALYSE                      *
*              Josef Brüderl                        *
*              November 2018                        *
*****************************************************

clear 
set more off
version 15

* Daten: ALLBUS 2002
cd "C:\Users\Brüderl\LRZ Sync+Share\Vorlesung Querschnittsdatenanalyse\Do Files\"
use  AllbReg, clear


* ---------------------------------------
* Datenaufbereitung
* ---------------------------------------
* Nur hauptberuflich ganztags, bis Alter 65
keep if  hauptber == 1
keep if  alter <  66


* ----------------------------------
* Multikollinearität
* ----------------------------------

* Interaktionsterme korrelieren stark
regress eink c.bild##frau c.exp##c.exp
estat vif

* Mit zentrierten Variablen ist das Problem geringer!
gen sample = ~ missing(eink,bild,frau) 
summ  bild                    if sample==1
gen   bild_cen = bild - r(mean)  if sample==1
regress eink c.bild_cen##frau c.exp##c.exp
estat vif


* -----------------------------------------
*  Linearitätsdiagnostik (Berufserfahrung)
* -----------------------------------------
regress eink bild exp frau
cprplot exp, lowess

* Linearitätsdiagnostik über gruppierte Variable
generate expgr = exp
recode expgr 0/10=1 10/20=2 20/30=3 30/40=4 40/50=5
regress eink bild frau i.expgr
margins expgr                   //Vorhergesagtes Einkommen in den Gruppen
marginsplot                     //Plot der vorhergesagten Werte
contrast p.expgr, asobserved    //Test, ob Polynomterme signifikant sind


* ----------------------------------
*  Homoskedastizität
* ----------------------------------
regress eink bild exp frau
est store m1
rvfplot, yline(0)

* Robuste S.E.s
regress eink bild exp frau, vce(robust)
est store m2

esttab m1 m2, b(%6.2f) star se r2


* ----------------------------------
*  Normalverteilungsannahme
* ----------------------------------
regress eink bild exp frau
predict res1, residual
qnorm res1 

* logarithmische Transformation der aV
generate  lneink  = ln(eink)
regress   lneink bild exp frau
rvfplot, yline(0)
predict res2, residual
qnorm res2 

cprplot exp, lowess      // nun ist die Linearitätsannahme verletzt ...


* ----------------------------------
*  Ausreißerdiagnostik
* ----------------------------------
regress eink bild exp frau
predict D, cooksd

* Partielle-Regressions Streudiagramme
avplots

* Indexplot von Cook's D
gen nr=_n
scatter D nr,  msymbol(i) mlabel(nr) mlabposition(0)
list eink bild exp frau if D>0.1 & D~=.

